function DragAndDrop(_object) {
    let _this = this;
    this.modal = document.createElement('div');
    this.modal.setAttribute('id', 'ModalActivity');
    this.modal.setAttribute('class', 'modal drag-drop');
    this.modal.innerHTML = '<div class="timer"></div><div class="content-modal activity-drag-and-drop"></div><div class="retro-option"></div>';
    this.data = Library.scenes[_object.id];
    this.positionObject = map.objects.indexOf(_object);
    this.autoRemove = _object.autoRemove;
    _object.state = this.autoRemove ? false:true; 
    this.openDoor = _object.openCell;
    this.appearObjects = _object.appearObjects;
    map.wallGrid[_object.closeCell.pos] =  _object.closeCell.wall;
    indexPista = "";
    this.counter = 0;
    this.points = 0;
    this.length = this.data.questions.length;;
    this.countDownTimer = null;
    this.isPreseed = false;
    this.pressedOption = null;
    this.cloneOption = null;
    this.eventPosition = null;
    document.body.append(this.modal);
    this.setEvents();
    this.drawIntro();
    utils.stopAllSounds();
    /* utils.sfx('dacti_pista6', { volume: 1, loop: false }); */
    utils.sfx('fondo-actividad', { volume: 0.1, loop: true });
    if(_object.html != 0)
        unlockContent(_object.html);
}
DragAndDrop.prototype.setEvents = function() {
    let _this = this;
    this.modal.addEventListener('click', function(e) {
        if(e.target.classList.contains('start')){
            _this.drawQuestion();
            if(_this.data.timer !== null)
                _this.timer();
            utils.sfx('boton', { volume: 1, loop: false });
        }
       
        if(e.target.classList.contains('btn-finish')){
            indexPista = _this.data.pista;
            /* if(indexPista != 'NULL'){
                document.getElementById('notification').setAttribute('data-audio', indexPista);
                document.getElementById('notification').style.display = 'flex';
                } */
            _this.modal.classList.remove('active');
            _this.modal.remove();
            _this.modal.querySelector('.content-modal').innerHTML = '';
            if(_this.autoRemove)
            {
                map.objects.splice(_this.positionObject, 1);
                document.querySelector('.click-modal').style.display = 'none';
            }
            delete activity;
            RUN = true;
            _this.appearObjects.forEach(idx => {
                config.objects[idx].state = true;
                appearObject(idx);
            });
            if("coords" in _this.data) { player.x = _this.data.coords.x, player.y = _this.data.coords.y }
            if("background" in _this.data) { map.setBackground(_this.data.background); }
            map.wallGrid[_this.openDoor] = 0;
            init();
            utils.sfx('boton', { volume: 1, loop: false });
        }
        if(e.target.classList.contains('btn-retro')){
            _this.modal.querySelector('.retro-option').classList.remove('active');
            utils.sfx('boton', { volume: 1, loop: false });
        }
    });
    this.modal.addEventListener('mousedown', this.onPress.bind(this, _this));
    this.modal.addEventListener('mouseup', this.onRelease.bind(this, _this));
    this.modal.addEventListener('mousemove', this.onMove.bind(this, _this));
    this.modal.addEventListener('touchstart', this.onPress.bind(this, _this));
    this.modal.addEventListener('touchmove', this.onMove.bind(this, _this));
    this.modal.addEventListener('touchend', this.onRelease.bind(this, _this));
}
DragAndDrop.prototype.drawIntro = function() {
    this.modal.classList.add('active');
    this.modal.querySelector('.content-modal').innerHTML = this.data.intro;
    this.modal.querySelector('.timer').style.visibility = 'hidden';
}
DragAndDrop.prototype.drawQuestion = function () {
    let html = '';
        html += '<div class="header">'+this.data.questions[this.counter].header+'</div>';
        html += '<div class="container-flex-activity">';
            html += '<img class="img-activity" src="'+this.data.questions[this.counter].image+'">';
            html += '<div class="content-activity-dragdrop">';
                html += '<div class="container-drop">';
                    for(let i = 0; i < this.data.questions[this.counter].options.length; i++)
                        html += '<div class="drop-content" data-drop="'+this.data.questions[this.counter].drop[i].letter+'" style="background:'+this.data.questions[this.counter].drop[i].bg+'"></div>';
                html += '</div>';
                html += '<div class="drag-content">';
                    for(let i = 0; i < this.data.questions[this.counter].options.length; i++)
                        html += '<div class="item-option" data-option="'+this.data.questions[this.counter].options[i].letter+'">'+this.data.questions[this.counter].options[i].text+'</div>';
                html += '</div>';
            html += '</div>';
        html += '</div>';
    this.modal.querySelector('.content-modal').classList.add('bg-activity');
    this.modal.querySelector('.timer').style.visibility = 'visible';
    this.modal.querySelector('.content-modal').innerHTML = html;
    utils.sfx('Sound-timer', { volume: 0.5, loop: true });
}
DragAndDrop.prototype.drawRetro = function() {
    let html = '';
    clearInterval(this.countDownTimer);
    this.data.retros.forEach(retro => {
        let validation = retro.validation.replace(/points/gi, this.points);
        if(eval(validation)){
            html += retro.information.replace(/XXX/gi, this.points );
        }
    });
    this.modal.querySelector('.content-modal').classList.remove('bg-activity');
    this.modal.querySelector('.content-modal').classList.add('bg-retro');
    this.modal.querySelector('.content-modal').innerHTML = html;
    utils.stopAllSounds();
    utils.sfx('act1-audio2', { volume: 0.6, loop: true });
}
DragAndDrop.prototype.timer = function() {
    let countDownDate = new Date();
    let _this = this;
    countDownDate.setSeconds(countDownDate.getSeconds() + this.data.timer);
    document.querySelector(".timer").classList.add('visible');
    this.countDownTimer = setInterval(function() {
        var now = new Date().getTime();
        distance = countDownDate.getTime() - now;
        var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
        var seconds = Math.floor((distance % (1000 * 60)) / 1000);
        stopTimer = seconds;
        if(seconds < 10) seconds = '0'+seconds;
        document.querySelector(".timer").innerHTML = minutes + ':' + seconds;
       
        if (distance < 0) {
          clearInterval(this.countDownTimer);
          _this.drawRetro();
          document.querySelector(".timer").innerHTML = 0+ ':' + 0;
        }
    }, 1000);
}
DragAndDrop.prototype.onPress = function(_this, e) {
    if(e.target.classList.contains('item-option')){
        let option = parseInt(e.target.getAttribute('data-option'));
        _this.pressedOption = e.target;
        _this.cloneOption = e.target.cloneNode(true);
        _this.cloneOption.classList.add('moving');
        _this.cloneOption.style.top = e.clientY != undefined ? e.clientY  + 'px' : e.touches[0].clientY + 'px';
        _this.cloneOption.style.left = e.clientX != undefined ? e.clientX+ 'px' : e.touches[0].clientX + 'px';
        _this.pressedOption.style.opacity = 0;
        _this.modal.querySelector('.content-modal').append(_this.cloneOption);
        _this.isPreseed = true;
        utils.sfx('boton', { volume: 1, loop: false });
    }
}
DragAndDrop.prototype.onMove = function(_this, e){
    if(_this.isPreseed){
        _this.eventPosition = e.clientX != undefined ? e : e.touches[0];
        _this.cloneOption.style.top = _this.eventPosition.clientY + 'px';
        _this.cloneOption.style.left = _this.eventPosition.clientX + 'px';
    }
}
DragAndDrop.prototype.onRelease = function(_this, e) {
    _this.isPreseed = false;
    if(_this.cloneOption !== null){
        _this.modal.querySelectorAll('.drop-content').forEach((dropContent) => {
            if(!dropContent.classList.contains('filled')){
                let rects = dropContent.getBoundingClientRect();
                try{
                    if(_this.eventPosition.clientY > rects.top && _this.eventPosition.clientY < (rects.top + rects.height) && _this.eventPosition.clientX > rects.left && _this.eventPosition.clientX < (rects.left + rects.width)){
                        let option = _this.pressedOption.getAttribute('data-option');
                        let dropOption = dropContent.getAttribute('data-drop');
                        if(option == dropOption) {
                            // if(_this.data.questions[_this.counter].points[option]> 0) utils.sfx('retro-bien', { volume: 1, loop: false });
                            // else utils.sfx('retro-mal', { volume: 1, loop: false });
                            dropContent.innerHTML = _this.cloneOption.innerHTML;
                            dropContent.setAttribute('data-option', option);
                            dropContent.classList.add('filled');
                            _this.modal.querySelector('.item-option[data-option="'+option+'"]').remove();
                            _this.check();
                        }        
                        else {
                            _this.pressedOption.style.opacity = 1;
                        }
                    }
                    else {
                        _this.pressedOption.style.opacity = 1;
                    }
                }
                catch(ev){
                    this.pressedOption.style.opacity = 1;
                }
            }
        });
        _this.cloneOption.remove();
        _this.cloneOption = null;
    } 
}
DragAndDrop.prototype.check = function() {
    let itemDrop = this.modal.querySelectorAll('.container-drop [data-option]').length;
    let totalDrop = this.data.questions[this.counter].drop.length;
    if(itemDrop == totalDrop)
    {
        let tmpPoints = 0;
        this.modal.querySelectorAll('.drop-content').forEach((dropContent) => {
            if(dropContent.getAttribute('data-drop')  == dropContent.getAttribute('data-option'))
                tmpPoints++;
        });
        this.points = Math.round(100 / totalDrop) * tmpPoints;
        this.counter++;
        if(this.counter < this.length){
            this.drawQuestion();
        } else {
            this.drawRetro();
        }
    }
}