function FieldInput(_object) {
    let _this = this;
    this.modal = document.createElement('div');
    this.modal.setAttribute('id', 'ModalActivity');
    this.modal.setAttribute('class', 'modal');
    this.modal.innerHTML = '<div class="btn-exit"></div><div class="content-modal field-input"></div>';
    this.data = Library.scenes[_object.id];
    this.positionObject = map.objects.indexOf(_object);
    this.autoRemove = _object.autoRemove;
    _object.state = this.autoRemove ? false:true; 
    this.openDoor = _object.openCell;
    this.appearObjects = _object.appearObjects;
    map.wallGrid[_object.closeCell.pos] =  _object.closeCell.wall;
    indexPista = "";
    document.body.append(this.modal);
    this.setEvents();
    this.drawContent();
    utils.stopAllSounds();
    utils.sfx('fondo-actividad', { volume: 0.2, loop: true });
    if(_object.html != 0)
        unlockContent(_object.html);
}

FieldInput.prototype.drawContent = function(){
    let html = '';
    console.log(this.data);
    html += '<div class="form"><h1>Ingresa el código: 362985</h1><img src="img/interfaz/tarjetas.png"><input type="number" maxlength="'+this.data.maxLength+'" placeholder="******"/> </div>';
    this.modal.querySelector('.content-modal').innerHTML = html;
    this.modal.classList.add('active');
}

FieldInput.prototype.setEvents = function () {
    let _this = this;
    this.modal.addEventListener('click', function(e) {
        if(e.target.classList.contains('btn-exit')){
            _this.modal.classList.remove('active');
            _this.modal.remove();
            _this.modal.querySelector('.content-modal').innerHTML = '';
            if(_this.autoRemove && indexPista.length > 0)
            {
                map.objects.splice(_this.positionObject, 1);
                document.querySelector('.click-modal').style.display = 'none';
            }
            delete activity;
            RUN = true;
           
            init();
            utils.sfx('boton', { volume: 1, loop: false });
        }
    });

    this.modal.addEventListener('input', function(e){
        if(e.target.value.length > e.target.maxLength)
        {
            e.target.value = e.target.value.slice(0, e.target.maxLength)
        }

        if(e.target.value.length === e.target.maxLength)
        {
            if(e.target.value == _this.data.code)
            {
                _this.modal.querySelector('.content-modal').innerHTML = _this.data.retroGood;
                indexPista = _this.data.pista;
                /* if(indexPista != 'NULL'){
                    document.getElementById('notification').setAttribute('data-audio', indexPista);
                    document.getElementById('notification').style.display = 'flex';
                    } */
                map.wallGrid[_this.openDoor] = 0;
                _this.appearObjects.forEach(idx => {
                    config.objects[idx].state = true;
                    appearObject(idx);
                })
            }
            else {
                _this.modal.querySelector('.content-modal').innerHTML = _this.data.retroWrong;
                indexPista = "";
            }
        }
    });
}