function Magnify(_object) {
    let _this = this;
    this.modal = document.createElement('div');
    this.modal.setAttribute('id', 'ModalActivity');
    this.modal.setAttribute('class', 'modal');
    this.modal.innerHTML = '<div class="btn-exit"><i class="fas fa-times-circle"></i></div><div class="content-modal magnify"></div>';
    this.data = Library.scenes[_object.id];
    this.positionObject = map.objects.indexOf(_object); 
    this.autoRemove = _object.autoRemove;
    _object.state = this.autoRemove ? false:true; 
    this.openDoor = _object.openCell;
    this.appearObjects = _object.appearObjects;
    map.wallGrid[_object.closeCell.pos] =  _object.closeCell.wall;
    indexPista = "";
    document.body.append(this.modal);
    this.setEvents();
    this.drawContent();
    utils.stopAllSounds();
    utils.sfx('fondo-actividad', { volume: 0.2, loop: true });
    if(_object.html != 0)
        unlockContent(_object.html);
}

Magnify.prototype.drawContent = function(){
    let zoom = 2;
    let html = '';
    html += '<div class="magnifier-container">';
    html += '<img id="Cover" class="img-cover" src="'+this.data.cover+'" />';
    html += '<div id="Glass" class="img-magnifier-glass" style="background-image: url('+this.data.reveal+')"></div>';
    html += '</div>';
    this.modal.querySelector('.content-modal').innerHTML = html;

    let img, glass, w, h, bw;
    img = document.getElementById('Cover');
    glass = document.getElementById('Glass');
   
    
    img.addEventListener("load", function() {
        glass.style.backgroundSize = (img.width * zoom) + "px " + (img.height * zoom) + "px";
        bw = 3;
        w = glass.offsetWidth / 2;
        h = glass.offsetHeight / 2;
    });

    window.addEventListener('resize', function(){
        console.log('resize');
        glass.style.backgroundSize = (img.width * zoom) + "px " + (img.height * zoom) + "px";
        bw = 3;
        w = glass.offsetWidth / 2;
        h = glass.offsetHeight / 2;
    });

    glass.addEventListener("mousemove", moveMagnifier);
    img.addEventListener("mousemove", moveMagnifier);
    glass.addEventListener("touchmove", moveMagnifier);
    img.addEventListener("touchmove", moveMagnifier);

    function moveMagnifier(e) {
      var pos, x, y;
      /* Prevent any other actions that may occur when moving over the image */
      e.preventDefault();
      /* Get the cursor's x and y positions: */
      pos = getCursorPos(e);
      x = pos.x;
      y = pos.y;
      /* Prevent the magnifier glass from being positioned outside the image: */
      if (x > img.width - (w / zoom)) {x = img.width - (w / zoom);}
      if (x < w / zoom) {x = w / zoom;}
      if (y > img.height - (h / zoom)) {y = img.height - (h / zoom);}
      if (y < h / zoom) {y = h / zoom;}
      /* Set the position of the magnifier glass: */
      glass.style.left = (x - w) + "px";
      glass.style.top = (y - h) + "px";
      /* Display what the magnifier glass "sees": */
      glass.style.backgroundPosition = "-" + ((x * zoom) - w + bw) + "px -" + ((y * zoom) - h + bw) + "px";
    }
  
    function getCursorPos(e) {
        var a, x = 0, y = 0;
        e = e || window.event;
        /* Get the x and y positions of the image: */
        a = img.getBoundingClientRect();
        /* Calculate the cursor's x and y coordinates, relative to the image: */
        x = e.pageX != undefined ? e.pageX - a.left : e.touches[0].clientX - a.left;
        y = e.pageY != undefined ? e.pageY - a.top : e.touches[0].clientY - a.top;
        /* Consider any page scrolling: */
        x = x - window.pageXOffset;
        y = y - window.pageYOffset;
        return {x : x, y : y};
    }

    this.modal.classList.add('active');
}

Magnify.prototype.setEvents = function () {
    let _this = this;
    this.modal.addEventListener('click', function(e) {
        if(e.target.classList.contains('btn-exit')){
            indexPista = _this.data.pista;
            /* if(indexPista != 'NULL'){
                document.getElementById('notification').setAttribute('data-audio', indexPista);
                document.getElementById('notification').style.display = 'flex';
                } */
            _this.modal.classList.remove('active');
            _this.modal.remove();
            _this.modal.querySelector('.content-modal').innerHTML = '';
            if(_this.autoRemove && indexPista.length > 0)
            {
                
                map.objects.splice(_this.positionObject, 1);
                document.querySelector('.click-modal').style.display = 'none';
            }
            delete activity;
            RUN = true;

            _this.appearObjects.forEach(idx => {
                config.objects[idx].state = true;
                appearObject(idx);
            })

            if("coords" in _this.data) { player.x = _this.data.coords.x, player.y = _this.data.coords.y }
            if("background" in _this.data) { map.setBackground(_this.data.background); }

            map.wallGrid[_this.openDoor] = 0;
            init();
            utils.sfx('boton', { volume: 1, loop: false });
        }
    });
}