function MultipleSelection(_object) {
    let _this = this;
    this.modal = document.createElement('div');
    this.modal.setAttribute('id', 'ModalActivity');
    this.modal.setAttribute('class', 'modal');
    this.modal.innerHTML = '<div class="timer"></div><div class="content-modal activity-multiple-selection"></div><div class="retro-option"></div>';
    this.data = Library.scenes[_object.id];
    this.positionObject = map.objects.indexOf(_object);
    this.autoRemove = _object.autoRemove;
    _object.state = this.autoRemove ? false:true; 
    this.openDoor = _object.openCell;
    this.appearObjects = _object.appearObjects;
    map.wallGrid[_object.closeCell.pos] =  _object.closeCell.wall;
    indexPista = "";
    this.counter = 0;
    this.tmpPoint = 0;
    this.points = 0;
    this.length = this.data.questions.length;;
    this.countDownTimer = null;
    document.body.append(this.modal);
    _this.setEvents();
    _this.drawIntro();
    utils.stopAllSounds();
    utils.sfx('dacti_pista6', { volume: 1, loop: false });
    utils.sfx('fondo-actividad', { volume: 0.2, loop: true });
    if(_object.html != 0)
        unlockContent(_object.html);
}

MultipleSelection.prototype.setEvents = function() {
    let _this = this;
    this.modal.addEventListener('click', function(e) {
        if(e.target.classList.contains('start')){
            _this.drawQuestion();
            if(_this.data.timer !== null)
                _this.timer();
            utils.sfx('boton', { volume: 1, loop: false });
        }
        if(e.target.classList.contains('btn-option')){
            
            _this.tmpPoint = 0; 
            if(e.target.classList.contains('active'))
            {
                e.target.classList.remove('active');
            }
            else {
                e.target.classList.add('active');
            }

            if(_this.modal.querySelectorAll('.btn-option.active').length > 0){
                _this.modal.querySelectorAll('.btn-option.active').forEach(btn => {
                    let option = parseInt(btn.getAttribute('data-option'));
                    _this.tmpPoint += _this.data.questions[_this.counter].points[option];
                });
                _this.modal.querySelector('.btn-next').style.display = "block";
            }
            else {
                _this.modal.querySelector('.btn-next').style.display = "none";
            };
            utils.sfx('boton', { volume: 1, loop: false });
            
        }

        if(e.target.classList.contains('btn-retro')){
            _this.modal.querySelector('.retro-option').classList.remove('active');
            utils.sfx('boton', { volume: 1, loop: false });
        }

        if(e.target.classList.contains('btn-next')){
            let tmpRetro = '';

            if(_this.tmpPoint == 50) { 
                tmpRetro = _this.data.questions[_this.counter].retros[0];
                utils.sfx('retro-bien', { volume: 1, loop: false });
            }
            else {
                tmpRetro = _this.data.questions[_this.counter].retros[1];
                utils.sfx('retro-mal', { volume: 1, loop: false });
            }

            _this.modal.querySelector('.retro-option').innerHTML = tmpRetro;
            _this.modal.querySelector('.retro-option').classList.add('active');

            _this.points += _this.tmpPoint;
            _this.counter++;
            if(_this.counter < _this.length){
                _this.drawQuestion();
            } else {
                _this.drawRetro();
            }
        }

        if(e.target.classList.contains('btn-finish')){
            indexPista = _this.data.pista;
            /* if(indexPista != 'NULL'){
                document.getElementById('notification').setAttribute('data-audio', indexPista);
                document.getElementById('notification').style.display = 'flex';
                } */
            _this.modal.classList.remove('active');
            _this.modal.remove();
            _this.modal.querySelector('.content-modal').innerHTML = '';
            if(_this.autoRemove)
            {
                map.objects.splice(_this.positionObject, 1);
                document.querySelector('.click-modal').style.display = 'none';
            }
            delete activity;
            RUN = true;
            _this.appearObjects.forEach(idx => {
                config.objects[idx].state = true;
                appearObject(idx);
            });

            if("coords" in _this.data) { player.x = _this.data.coords.x, player.y = _this.data.coords.y }
            if("background" in _this.data) { map.setBackground(_this.data.background); }

            map.wallGrid[_this.openDoor] = 0;
            init();
            utils.sfx('boton', { volume: 1, loop: false });
        }
    });
}

MultipleSelection.prototype.drawIntro = function() {
    this.modal.classList.add('active');
    this.modal.querySelector('.content-modal').innerHTML = this.data.intro;
    this.modal.querySelector('.timer').style.visibility = 'hidden';
}

MultipleSelection.prototype.drawQuestion = function () {
    let html = '';
        html += '<div class="header">'+this.data.questions[this.counter].header+'</div>';
        html += '<ul>';
            for(let i = 0; i < this.data.questions[this.counter].options.length; i++)
                html += '<li class="btn-option" data-option="'+i+'">'+this.data.questions[this.counter].options[i]+'</li>';
        html += '</ul>';
        html += '<button class="btn-next">Responder</button>';
    this.modal.querySelector('.content-modal').classList.add('bg-activity');
    this.modal.querySelector('.timer').style.visibility = 'visible';
    this.modal.querySelector('.content-modal').innerHTML = html;
    utils.sfx('Sound-timer', { volume: 0.5, loop: true });
}

MultipleSelection.prototype.drawRetro = function() {
    let html = '';
    this.points = this.points < 0 ? 0 : this.points;
    clearInterval(this.countDownTimer);
    this.data.retros.forEach(retro => {
        let validation = retro.validation.replace(/points/gi, this.points);
        if(eval(validation)){
            html += retro.information.replace(/XXX/gi, this.points );
        }
    });
    this.modal.querySelector('.content-modal').classList.remove('bg-activity');
    this.modal.querySelector('.content-modal').classList.add('bg-retro');
    this.modal.querySelector('.content-modal').innerHTML = html;
}

MultipleSelection.prototype.timer = function() {
    let countDownDate = new Date();
    let _this = this;
    countDownDate.setSeconds(countDownDate.getSeconds() + this.data.timer);
    document.querySelector(".timer").classList.add('visible');

    this.countDownTimer = setInterval(function() {
        var now = new Date().getTime();
        distance = countDownDate.getTime() - now;
        var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
        var seconds = Math.floor((distance % (1000 * 60)) / 1000);
        stopTimer = seconds;
        if(seconds < 10) seconds = '0'+seconds;
        document.querySelector(".timer").innerHTML = minutes + ':' + seconds;
       
        if (distance < 0) {
          clearInterval(this.countDownTimer);
          _this.drawRetro();
          document.querySelector(".timer").innerHTML = 0+ ':' + 0;
        }
    }, 1000);
}