function PairCards(_object) {
    let _this = this;
    this.modal = document.createElement('div');
    this.modal.setAttribute('id', 'ModalActivity');
    this.modal.setAttribute('class', 'modal pair');
    this.modal.innerHTML = '<div class="timer"></div><div class="content-modal activity-pair-cards"></div>';
    this.data = Library.scenes[_object.id];
    this.positionObject = map.objects.indexOf(_object);
    this.autoRemove = _object.autoRemove;
    _object.state = this.autoRemove ? false:true;
    this.appearObjects = _object.appearObjects;
    map.wallGrid[_object.closeCell.pos] =  _object.closeCell.wall;
    indexPista = "";
    this.counter = 0;
    this.points = 0;
    this.length = 1;
    this.countDownTimer = null;
    document.body.append(this.modal);
    this.setEvents();
    this.drawIntro();
    utils.stopAllSounds();
    utils.sfx('act17-audio1', { volume: 1, loop: false });
    utils.sfx('fondo-actividad', { volume: 0.2, loop: true });
    if(_object.html != 0)
        unlockContent(_object.html);
}

PairCards.prototype.setEvents = function() {
    let _this = this;
    let tmpValue = [];
    this.modal.addEventListener('click', function(e) {
        if(e.target.classList.contains('start')){
            _this.drawCards();
            _this.timer();
            utils.sfx('boton', { volume: 1, loop: false });
        }
    
        if(e.target.classList.contains('btn-finish')){
            indexPista = _this.data.pista;
            /* if(indexPista != 'NULL'){
                document.getElementById('notification').setAttribute('data-audio', indexPista);
                document.getElementById('notification').style.display = 'flex';
                } */
            _this.modal.classList.remove('active');
            _this.modal.remove();
            _this.modal.querySelector('.content-modal').innerHTML = '';
            if(_this.autoRemove)
            {
                map.objects.splice(_this.positionObject, 1);
                document.querySelector('.click-modal').style.display = 'none';
            }
            delete activity;
            RUN = true;
            _this.appearObjects.forEach(idx => {
                config.objects[idx].state = true;
                appearObject(idx);
            });

            if("coords" in _this.data) { player.x = _this.data.coords.x, player.y = _this.data.coords.y }
            if("background" in _this.data) { map.setBackground(_this.data.background); }

            map.wallGrid[_this.openDoor] = 0;
            init();
            utils.sfx('boton', { volume: 1, loop: false });
        }

        if(e.path[3].classList.contains('flip-card') && !e.path[3].classList.contains('blocked') && _this.counter < 2) {
            if(!e.path[3].classList.contains('active')){
                e.path[3].classList.add('active');
                _this.modal.querySelector('.content-description').innerHTML = e.path[3].getAttribute('data-text');
                tmpValue.push(e.path[3].getAttribute('data-id'));
                _this.counter++;
                utils.sfx('boton', { volume: 1, loop: false });
                if(_this.counter == 2)
                {
                    if(tmpValue[0] == tmpValue[1]){
                        utils.sfx('retro-bien', { volume: 1, loop: false });
                        _this.modal.querySelectorAll('.flip-card.active').forEach((el) => {
                            el.classList.remove('active');
                            el.classList.add('blocked');
                            _this.points += 100 / _this.data.cards.length;
                            if(_this.points > 99){
                                _this.drawRetro();
                            }
                        })
                        _this.counter = 0;
                        tmpValue = [];
                    }
                    else {
                        utils.sfx('retro-mal', { volume: 1, loop: false });
                        setTimeout(() => {
                            _this.modal.querySelectorAll('.flip-card.active').forEach((el) => {
                                el.classList.remove('active');
                            })
                            tmpValue = [];
                            _this.counter = 0;
                        },2000);
                        
                    }
                }
            }
        }

    });
}

PairCards.prototype.drawIntro = function() {
    this.modal.classList.add('active');
    this.modal.querySelector('.content-modal').innerHTML = this.data.intro;
    this.modal.querySelector('.timer').style.visibility = 'hidden';
}

PairCards.prototype.drawCards = function () {
    let html = '';
    html += '<div class="content-title">'+this.data.title+'</div>';
    html += '<div class="content-cards">'
        this.data.cards.forEach((el) => {
            html += '<div class="flip-card" data-id="'+el.id+'" data-text="'+el.text+'">';
                html += '<div class="flip-card-inner">';
                    html += '<div class="flip-card-front">'
                        html += '<img src="'+this.data.cover+'">';
                    html += '</div>';
                    html += '<div class="flip-card-back">'
                        html += '<img src="'+el.image+'">';
                    html += '</div>';
                html += '</div>';
            html += '</div>';
        });
    html += '</div>';
    html += '<div class="content-description"></div>';
    this.modal.querySelector('.content-modal').classList.add('bg-activity');
    this.modal.querySelector('.timer').style.visibility = 'visible';
    this.modal.querySelector('.content-modal').innerHTML = html;
    utils.sfx('Sound-timer', { volume: 0.5, loop: true });
}

PairCards.prototype.drawRetro = function() {
    let html = '';
    this.points = Math.round(this.points);
    clearInterval(this.countDownTimer);
    this.data.retros.forEach(retro => {
        let validation = retro.validation.replace(/points/gi, this.points);
        if(eval(validation)){
            html += retro.information.replace(/XXX/gi, this.points );
        }
    });
    this.modal.querySelector('.content-modal').classList.remove('bg-activity');
    this.modal.querySelector('.content-modal').classList.add('bg-retro');
    this.modal.querySelector('.content-modal').innerHTML = html;
}

PairCards.prototype.timer = function() {
    let countDownDate = new Date();
    let _this = this;
    countDownDate.setSeconds(countDownDate.getSeconds() + this.data.timer);
    document.querySelector(".timer").classList.add('visible');

    this.countDownTimer = setInterval(function() {
        var now = new Date().getTime();
        distance = countDownDate.getTime() - now;
        var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
        var seconds = Math.floor((distance % (1000 * 60)) / 1000);
        stopTimer = seconds;
        if(seconds < 10) seconds = '0'+seconds;
        document.querySelector(".timer").innerHTML = minutes + ':' + seconds;
       
        if (distance < 0) {
          clearInterval(this.countDownTimer);
          _this.drawRetro();
          document.querySelector(".timer").innerHTML = 0+ ':' + 0;
        }
    }, 1000);
}