var SPEED_BULLET = 0.3;
var ANGLE_BULLET = 0;
function Camera(canvas, resolution, fov) {
	this.ctx = canvas.getContext('2d');
	this.width = canvas.width = window.innerWidth;
	this.height = canvas.height = window.innerHeight;
	this.resolution = resolution;
	this.spacing = this.width / resolution;
	this.fov = fov;
	this.range = MOBILE ? 45 : 50;
	this.lightRange = 5;
	this.scale = (this.width + this.height) / 1200;
}

Camera.prototype.render = function(player, map, objects) {
	this.drawSky(player.direction, map.skybox);
	this.drawColumns(player, map, objects);
	this.drawMiniMap(map, player);
};

Camera.prototype.drawSky = function(direction, sky) {
	var width = this.width * (CIRCLE / this.fov);
	var left = -width * direction / CIRCLE;

	this.ctx.save();
	this.ctx.drawImage(sky.image, left, 0, width, this.height);
	if (left < width - this.width) {
		this.ctx.drawImage(sky.image, left + width, 0, width, this.height);
	}
	this.ctx.restore();
};

Camera.prototype.drawSpriteColumn = function(player,map,column,columnProps,sprites) {
	
	var ctx = this.ctx,
		left = Math.floor(column * this.spacing),
		width = Math.ceil(this.spacing),
		angle = this.fov * (column / this.resolution - 0.5),
		columnWidth = this.width / this.resolution,
		sprite,props,obj,textureX,height,projection, mappedColumnObj,spriteIsInColumn,top;

	//todo: make rays check for objects, and return those that it actually hit

	//check if ray hit an object
	//if(!columnProps.objects.length){return;}

	sprites = sprites.filter(function(sprite){
	 return !columnProps.hit || sprite.distanceFromPlayer < columnProps.hit;
	});


	for(var i = 0; i < sprites.length; i++){
		sprite = sprites[i];

		//determine if sprite should be drawn based on current column position and sprite width
		spriteIsInColumn =  left > sprite.render.cameraXOffset - ( sprite.render.width / 2 ) && left < sprite.render.cameraXOffset + ( sprite.render.width / 2 );

		if(spriteIsInColumn){
			textureX = Math.floor( sprite.texture.width / sprite.render.numColumns * ( column - sprite.render.firstColumn ) );

			this.ctx.fillStyle = 'black';
			this.ctx.globalAlpha = 1;
			ctx.fillRect(left, top , 10, sprite.render.height);
			ctx.drawImage(sprite.texture.image, textureX, 0, 1, sprite.texture.height, left, sprite.render.top, width, sprite.render.height);
		}

		
	};

};

Camera.prototype.drawSprites = function(player,map,columnProps){

	var screenWidth = this.width,
		screenHeight = this.height,
		screenRatio = screenWidth / this.fov,
		resolution = this.resolution;

	//probably should get these and pass them in, but modifying originals for now
	// also this limits size of world

	// calculate each sprite distance to player
	this.setSpriteDistances(map.objects, player);


	var sprites = Array.prototype.slice.call(map.objects)
		.map(function(sprite){

			var distX = sprite.x - player.x,
				distY = sprite.y - player.y,
				width = sprite.width * screenWidth / sprite.distanceFromPlayer,
				height = sprite.height * screenHeight /  sprite.distanceFromPlayer,
				
				angleToPlayer = Math.atan2(distY,distX),
				angleRelativeToPlayerView = player.direction - angleToPlayer,
				top = (screenHeight / 2) * (1 + 1 / sprite.distanceFromPlayer) - height;

			if(angleRelativeToPlayerView >= CIRCLE / 2){
				angleRelativeToPlayerView -= CIRCLE;    
			}

			var cameraXOffset = ( camera.width / 2 ) - (screenRatio * angleRelativeToPlayerView),
				numColumns = width / screenWidth * resolution,
				firstColumn = Math.floor( (cameraXOffset - width/2 ) / screenWidth * resolution);

			sprite.distanceFromPlayer = Math.sqrt( Math.pow( distX, 2) + Math.pow( distY, 2) );
			sprite.render = {
				width: width,
				height: height,
				angleToPlayer: angleRelativeToPlayerView,
				cameraXOffset: cameraXOffset,
				distanceFromPlayer: sprite.distanceFromPlayer,
				numColumns: numColumns,
				firstColumn: firstColumn,
				top: top
			};

			return sprite;
		})
		// sort sprites in distance order
		.sort(function(a,b){
			if(a.distanceFromPlayer < b.distanceFromPlayer){
				return 1;
			}
			if(a.distanceFromPlayer > b.distanceFromPlayer){
				return -1;
			}
			return 0;
		});

		if(sprites.length > 1 ){
			//debugger;
		}

	this.ctx.save();
	for (var column = 0; column < this.resolution; column++) {
		this.drawSpriteColumn(player,map,column,columnProps[column], sprites);
	}
	this.ctx.restore();
};

Camera.prototype.setSpriteDistances = function(objects, player){
	for(i = 0; i < objects.length; i++){
		obj = objects[i];
	}
};


Camera.prototype.drawColumns = function(player, map, objects) {
	this.ctx.save();
	var allObjects = [];
	for (var column = 0; column < this.resolution; column++) {
		var angle = this.fov * (column / this.resolution - 0.5);
		var ray = map.cast(player, player.direction + angle, this.range);
		var columnProps = this.drawColumn(column, ray, angle, map);

		allObjects.push(columnProps);
	}
	this.ctx.restore();
	this.ctx.save();
	this.drawSprites(player,map,allObjects);
	this.ctx.restore();
};

Camera.prototype.drawMiniMap = function(map, player) {

	var ctx = this.ctx,
		mapWidth = this.width * .15,
		mapHeight = mapWidth,
		x = this.width - mapWidth - 20,
		y = 20,
		blockWidth = mapWidth / map.size,
		blockHeight = mapHeight / map.size,
		radius = blockWidth * 0.40,
		playerX = player.x / map.size * mapWidth, // coords on map
		playerY = player.y / map.size * mapWidth,
		wallIndex,
		triangleX = x + playerX,
		triangleY = y + playerY;

	
	


	ctx.save();

	ctx.globalAlpha = .7;
	
	
	ctx.fillRect(x, y, mapWidth, mapHeight);
	ctx.globalAlpha = .8;
	ctx.fillStyle = '#00e1ff';

	for (var row = 0; row < map.size; row++) {
		for (var col = 0; col < map.size; col++) {
			
			
			wallIndex = row * map.size + col;

			if (map.wallGrid[wallIndex]) {
				
				ctx.fillRect(x + (blockWidth * col), y + (blockHeight * row), blockWidth, blockHeight);
			}

		}
	}

	ctx.save();

	var circleRadius = radius +  Math.sin(ANGLE_BULLET) * (radius * 0.1);
	var opacity = 0.5 + Math.sin(ANGLE_BULLET) + (0.8);
	ANGLE_BULLET += SPEED_BULLET;

	for (var i = 0; i < map.objects.length; i++){
		if(map.objects[i]){
			
			ctx.fillStyle = map.objects[i].color || 'blue';

			ctx.globalAlpha = opacity;
			ctx.beginPath();
			ctx.arc(
				x + (blockWidth * map.objects[i].x),
				y + (blockHeight * map.objects[i].y),
				circleRadius,
				0,
				2 * Math.PI
			);
			ctx.fill();
			/*
			ctx.fillRect(
				x + (blockWidth * map.objects[i].x) + blockWidth * .25,
				y + (blockHeight * map.objects[i].y) + blockWidth * .25,
				blockWidth * .5,
				blockHeight * .5
			);
			*/
		}
	}
	
		ctx.restore();
 

	//player triangle
	ctx.globalAlpha = 1;
	ctx.fillStyle = '#00A3AD';
	ctx.moveTo(triangleX,triangleY);
	ctx.translate(triangleX,triangleY);
	
	ctx.rotate(player.direction - Math.PI * .5);
	ctx.beginPath();
	ctx.lineTo(-4, -6); // bottom left of triangle
	ctx.lineTo(0, 4); // tip of triangle
	ctx.lineTo(4,-6); // bottom right of triangle
	ctx.fill();


	ctx.restore();

};

Camera.prototype.drawColumn = function(column, ray, angle, map) {
	var ctx = this.ctx,
	casa1 = map.casa1,
	casa2 = map.casa2,
	casa3 = map.casa3,
	casa4 = map.casa4,
	casa5 = map.casa5,
	casa6 = map.casa6,
	casa7 = map.casa7,
	casa8 = map.casa8,
	casa9 = map.casa9,
	casa10 = map.casa10,
	casa11 = map.casa11,
	casa12 = map.casa12,
	casa13 = map.casa13,
	casa14 = map.casa14,
	casa15 = map.casa15,
	casa16 = map.casa16,
	casa17 = map.casa17,
	casa18 = map.casa18,
	casa19 = map.casa19,
	casa20 = map.casa20,
	casa21 = map.casa21,
	casa22 = map.casa22,
	casa23 = map.casa23,
	casa24 = map.casa24,
	casa25 = map.casa25,
	casa26 = map.casa26,
	casa27 = map.casa27,
	casa28 = map.casa28,
	casa29 = map.casa29,
	casa30 = map.casa30,
	casa31 = map.casa31,
	casa32 = map.casa32,
	casa33 = map.casa33,
	casa34 = map.casa34,
	casa35 = map.casa35,
	casa36 = map.casa36,
	casa37 = map.casa37,
	casa38 = map.casa38,
	casa39 = map.casa39,
	casa40 = map.casa40,
	casa41 = map.casa41,
	casa42 = map.casa42,
	casa43 = map.casa43,
	casa44 = map.casa44,
	casa45 = map.casa45,
	casa46 = map.casa46,
	casa47 = map.casa47,
	casa48 = map.casa48,
	casa49 = map.casa49,
	casa50 = map.casa50,
	casa51 = map.casa51,
	casa52 = map.casa52,
	casa53 = map.casa53,
	casa54 = map.casa54,
	casa55 = map.casa55,
	casa56 = map.casa56,
	casa57 = map.casa57,
	casa58 = map.casa58,
		left = Math.floor(column * this.spacing),
		width = Math.ceil(this.spacing),
		hit = -1,
		objects = [],
		hitDistance;

	while (++hit < ray.length && ray[hit].height <= 0);

	for (var s = ray.length - 1; s >= 0; s--) {
		var step = ray[s];
		if (s === hit) {
			textureX = Math.floor(casa1.width * step.offset);
			wall = this.project((step.height/step.height), angle, step.distance);
			ctx.globalAlpha = 1;
			ctx.imageSmoothingEnabled = true;
			if(step.value == 1){
				//Params (url, pixelX de la imagen, pixelY de imagen, )
				ctx.drawImage(casa1.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 2){
				ctx.drawImage(casa2.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 3){
				ctx.drawImage(casa3.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 4){
				ctx.drawImage(casa4.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 5){
				ctx.drawImage(casa5.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 6){
				ctx.drawImage(casa6.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 7){
				ctx.drawImage(casa7.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 8){
				ctx.drawImage(casa8.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 9){
				ctx.drawImage(casa9.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 10){
				ctx.drawImage(casa10.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 11){
				ctx.drawImage(casa11.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 12){
				ctx.drawImage(casa12.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 13){
				ctx.drawImage(casa13.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 14){
				ctx.drawImage(casa14.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 15){
				ctx.drawImage(casa15.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 16){
				ctx.drawImage(casa16.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 17){
				ctx.drawImage(casa17.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}

			else if(step.value == 18){
				ctx.drawImage(casa18.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}

			else if(step.value == 19){
				ctx.drawImage(casa19.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 20){
				ctx.drawImage(casa20.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 21){
				ctx.drawImage(casa21.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 22){
				ctx.drawImage(casa22.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 23){
				ctx.drawImage(casa23.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 24){
				ctx.drawImage(casa24.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 25){
				ctx.drawImage(casa25.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 26){
				ctx.drawImage(casa26.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 27){
				ctx.drawImage(casa27.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 28){
				ctx.drawImage(casa28.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 29){
				ctx.drawImage(casa29.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 30){
				ctx.drawImage(casa30.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 31){
				ctx.drawImage(casa31.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 32){
				ctx.drawImage(casa32.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 33){
				ctx.drawImage(casa33.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 34){
				ctx.drawImage(casa34.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 35){
				ctx.drawImage(casa35.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 36){
				ctx.drawImage(casa36.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 37){
				ctx.drawImage(casa37.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 38){
				ctx.drawImage(casa38.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 39){
				ctx.drawImage(casa39.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 40){
				ctx.drawImage(casa40.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 41){
				ctx.drawImage(casa41.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 42){
				ctx.drawImage(casa42.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 43){
				ctx.drawImage(casa43.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 44){
				ctx.drawImage(casa44.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 45){
				ctx.drawImage(casa45.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 46){
				ctx.drawImage(casa46.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 47){
				ctx.drawImage(casa47.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 48){
				ctx.drawImage(casa48.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 49){
				ctx.drawImage(casa49.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 50){
				ctx.drawImage(casa50.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 51){
				ctx.drawImage(casa51.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 52){
				ctx.drawImage(casa52.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 53){
				ctx.drawImage(casa53.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 54){
				ctx.drawImage(casa54.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 55){
				ctx.drawImage(casa55.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 56){
				ctx.drawImage(casa56.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 57){
				ctx.drawImage(casa57.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}
			else if(step.value == 58){
				ctx.drawImage(casa58.image, textureX, 0, 1, casa1.height, left, wall.top, width, wall.height);
			}




			// ctx.fillStyle = '#000000';
			// ctx.globalAlpha = Math.max((step.distance + step.shading) / this.lightRange - map.light, 0);
			// ctx.fillRect(left, wall.top, width, wall.height);
	
			hitDistance = step.distance;
		} else if(step.object){

			objects.push({
				object: step.object,
				distance: step.distance,
				offset: step.offset,
				angle: angle
			});

		}
	}
	return {
		objects: objects,
		hit: hitDistance
	}
};

Camera.prototype.project = function(height, angle, distance) {
	var z = distance * Math.cos(angle);
	var wallHeight = this.height * height / z;
	var bottom = this.height / 2 * (1 + 1 / z);
	return {
		top: bottom - wallHeight,
		height: wallHeight
	};
};
/*
Camera.prototype.projectSprite = function(height, distance) {
	var z = distance;
	var wallHeight = this.height * height / z;
	var bottom = this.height / 2 * (1 + 1 / z);
	return {
		top: bottom - wallHeight,
		height: wallHeight
	};
};*/