function Controls() {
	this.controls = {
		'openModal': document.getElementById('OpenModal'),
		'up': document.getElementById('KeyUp'),
		'left': document.getElementById('KeyLeft'),
		'down': document.getElementById('KeyDown'),
		'right': document.getElementById('KeyRight')
	}
	this.codes = {
		37: 'left', // left arrow
		39: 'right', // right arrow
		38: 'forward', // up arrow
		40: 'backward', // down arrow
	}
	this.states = {
		'left': false,
		'right': false,
		'forward': false,
		'backward': false,
		'running': false
	};
	document.addEventListener('keydown', this.onKey.bind(this, true), false);
	document.addEventListener('keyup', this.onKey.bind(this, false), false);

	this.controls['openModal'].addEventListener('click', function() { PRESS = true; }.bind(this));
	this.controls['openModal'].addEventListener('mouseup', function() { PRESS = false; }.bind(this));

	this.controls['up'].addEventListener('mousedown', function() { this.controls['up'].classList.add('active'); this.onKey(true, { keyCode: 38 }) }.bind(this));
	this.controls['up'].addEventListener('touchstart', function() { this.controls['up'].classList.add('active'); this.onKey(true, { keyCode: 38 })}.bind(this));
	this.controls['left'].addEventListener('mousedown', function() { this.controls['left'].classList.add('active'); this.onKey(true, { keyCode: 37 }) }.bind(this));
	this.controls['left'].addEventListener('touchstart', function() { this.controls['left'].classList.add('active'); this.onKey(true, { keyCode: 37 })}.bind(this));
	this.controls['down'].addEventListener('mousedown', function() { this.controls['down'].classList.add('active'); this.onKey(true, { keyCode: 40 }) }.bind(this));
	this.controls['down'].addEventListener('touchstart', function() { this.controls['down'].classList.add('active'); this.onKey(true, { keyCode: 40 })}.bind(this));
	this.controls['right'].addEventListener('mousedown', function() { this.controls['right'].classList.add('active'); this.onKey(true, { keyCode: 39 }) }.bind(this));
	this.controls['right'].addEventListener('touchstart', function() { this.controls['right'].classList.add('active'); this.onKey(true, { keyCode: 39 })}.bind(this));

	this.controls['up'].addEventListener('mouseup', this.onTouchEnd.bind(this), false);
	this.controls['up'].addEventListener('touchend', this.onTouchEnd.bind(this), false);
	this.controls['left'].addEventListener('mouseup', this.onTouchEnd.bind(this), false);
	this.controls['left'].addEventListener('touchend', this.onTouchEnd.bind(this), false);
	this.controls['down'].addEventListener('mouseup', this.onTouchEnd.bind(this), false);
	this.controls['down'].addEventListener('touchend', this.onTouchEnd.bind(this), false);
	this.controls['right'].addEventListener('mouseup', this.onTouchEnd.bind(this), false);
	this.controls['right'].addEventListener('touchend', this.onTouchEnd.bind(this), false);
}

Controls.prototype.onTouchEnd = function(e) {
    this.states = { 'left': false, 'right': false, 'forward': false, 'backward': false };
	this.controls['up'].classList.remove('active');
	this.controls['left'].classList.remove('active');
	this.controls['down'].classList.remove('active');
	this.controls['right'].classList.remove('active');

	if(e.target.classList.contains('content-game')){
		e.preventDefault();
		e.stopPropagation();
	}
};

Controls.prototype.onKey = function(val, e) {
	if(!RUN)
		loop.stop();
	var state = this.codes[e.keyCode];

	this.states.running = e.shiftKey;

	if (typeof state === 'undefined') return;
	this.states[state] = val;
	//this.states.crouching = e.ctrlKey;
	e.preventDefault && e.preventDefault();
	e.stopPropagation && e.stopPropagation();
};


