function GameLoop() {
	this.frame = this.frame.bind(this);
	this.lastTime = 0;
	this.callback = function() {};
}

GameLoop.prototype.start = function(callback) {
	this.callback = callback;
	this.rq = requestAnimationFrame(this.frame);
}

GameLoop.prototype.frame = function(time) {
	var seconds = (time - this.lastTime) / 1000;
	this.lastTime = time;
	if (seconds < 0.2) this.callback(seconds);
	if(RUN)
		this.rq = requestAnimationFrame(this.frame);
};

GameLoop.prototype.stop = function() {
	window.cancelAnimationFrame(this.rq);
}

window.addEventListener('resize', function(){
	var fullscreen = camera.fullscreen;
	camera = new Camera(display, MOBILE ? 160 : 320, Math.PI * .4);
	camera.fullscreen = fullscreen;
});

function removeInstructions(){
	var instructions = document.getElementById('instructions');
	instructions.parentNode.removeChild(instructions);

}