const Loader = {
    imageSources: [],
    soundSources: [],
    sceneSources: [],
	contentSources: [],
    onPreloaded: new CustomEvent('preloaded')
};

window.Library = {
    images: {},
    sounds: {},
    scenes: {},
	contents: {}
};

Loader.load = (progressCallback) => {
	
    let totalAssets = Loader.imageSources.length + Loader.soundSources.length + Loader.sceneSources.length + Loader.contentSources.length;
    let assetsLoaded = 0;
    window.addEventListener('preloaded', () => {
        assetsLoaded++;
        progressCallback(Math.round((100/totalAssets) * assetsLoaded));
    });

    return new Promise((resolve) => {
        let loadPromises = [];
        Loader.imageSources.forEach(function(config){
            loadPromises.push(Loader.loadImage(config));
        });

        Loader.soundSources.forEach(function(config){
            loadPromises.push(Loader.loadSound(config));
        });

        Loader.sceneSources.forEach(function(config){
            loadPromises.push(Loader.loadScene(config));
        });

		Loader.contentSources.forEach(function(config){
            loadPromises.push(Loader.loadContent(config));
        });

        Promise.all(loadPromises).then(resolve);
    });
}

/////////////////////////////
// IMAGES ///////////////////
/////////////////////////////

Loader.addImages = function(imageConfigs){
	Loader.imageSources = Loader.imageSources.concat(imageConfigs);
};

Loader.loadImage = function(imageConfig){
	return new Promise(function(resolve){
		fetch(imageConfig.src)
			.then(response => response.blob())
			.then(blobData => utils.createImageBitmap(blobData))
			.then(bitmap => {
				bitmap.hackSrc = imageConfig.src;
				Library.images[imageConfig.id] = bitmap;
                dispatchEvent(Loader.onPreloaded);
				resolve();
            });
	});
};


/////////////////////////////
// SOUNDS ///////////////////
/////////////////////////////

Loader.addSounds = function(soundConfigs){
	Loader.soundSources = Loader.soundSources.concat(soundConfigs);
};

Loader.loadSound = function(soundConfig){
	return new Promise(function(resolve){
		let sound = new Howl({
			src: [soundConfig.src]
		});
		Library.sounds[soundConfig.id] = sound; // ADD TO LIBRARY
		sound.once("load",function(){
			dispatchEvent(Loader.onPreloaded);
			resolve();
		});
	});
};

/////////////////////////////
// SCENES ///////////////////
/////////////////////////////

Loader.addScenes = function(sceneConfigs){
	Loader.sceneSources = Loader.sceneSources.concat(sceneConfigs);
};

Loader.loadScene = function(sceneConfig){
	return new Promise(function(resolve){
		var xhr = new XMLHttpRequest();
		xhr.open("GET", sceneConfig.src);
		xhr.onload = function() {
		    if(xhr.status===200){
		    	Library.scenes[sceneConfig.id] = JSON.parse(xhr.responseText);
                dispatchEvent(Loader.onPreloaded);
		    	resolve();
		    }
		};
		xhr.send();
	});
};

/////////////////////////////
// CONTENTS /////////////////
/////////////////////////////

Loader.addContents = function(contentConfigs){
	Loader.contentSources = Loader.contentSources.concat(contentConfigs);
};

Loader.loadContent = function(contentConfig){
	return new Promise(function(resolve){
		var xhr = new XMLHttpRequest();
		xhr.open("GET", contentConfig.src);
		xhr.onload = function() {
		    if(xhr.status===200){
		    	Library.contents[contentConfig.id] = xhr.response;
                dispatchEvent(Loader.onPreloaded);
		    	resolve();
		    }
		};
		xhr.send();
	});
};