var CIRCLE = Math.PI * 2;
var MOBILE = /Android|webOS|iPhone|iPad|iPod|BlackBerry/i.test(navigator.userAgent);
var RUN = true;
var PRESS = false;

var display = document.getElementById('display'),
	modalIntro = document.getElementById('ModalIntro'),
	popupCharacter = document.getElementById('Character'),
	tablet = document.getElementById('Tablet'),
	player = null,
	map = new Map(Math.sqrt(config.level.length)),
	objects = new Objects(),
	controls = new Controls(),
	camera = new Camera(display, MOBILE ? 160 : 320, Math.PI * .4),
	loop = new GameLoop(),
	activity = null,
	mute = false,
	indexPista = "";
//////////// SALA 1 ///////////
	map.addObject({
		id: -1,// columna 01

		color: 'transparent',
		texture: new Bitmap('img/flotantes/columna.png', 1200, 1200),
		height: 1.2,
		width: 1,
		floorOffset: 0,
		speed: .1
	},8.5,2.5);

	map.addObject({
		id: -1,// columna 02

		color: 'transparent',
		texture: new Bitmap('img/flotantes/columna_2.png', 1200, 1200),
		height: 1.2,
		width: 1,
		floorOffset: 0,
		speed: .1
	},11.5,2.5);

	map.addObject({
		id: -1,// columna 03

		color: 'transparent',
		texture: new Bitmap('img/flotantes/columna_3.png', 1200, 1200),
		height: 1.2,
		width: 1,
		floorOffset: 0,
		speed: .1
	},8.5,4.5);

	map.addObject({
		id: -1,// columna 04

		color: 'transparent',
		texture: new Bitmap('img/flotantes/columna.png', 1200, 1200),
		height: 1.2,
		width: 1,
		floorOffset: 0,
		speed: .1
	},11.5,4.5);

	
	map.addObject({
		id: -1,// columna 05

		color: 'transparent',
		texture: new Bitmap('img/flotantes/columna_2.png', 1200, 1200),
		height: 1.2,
		width: 1,
		floorOffset: 0,
		speed: .1
	},8.5,6.5);

	map.addObject({
		id: -1,// columna 06

		color: 'transparent',
		texture: new Bitmap('img/flotantes/columna_3.png', 1200, 1200),
		height: 1.2,
		width: 1,
		floorOffset: 0,
		speed: .1
	},11.5,6.5);
//////////////////// Comedores


map.addObject({
	id: -1,// comedor 01

	color: 'transparent',
	texture: new Bitmap('img/flotantes/comedor_1.png', 1200, 1200),
	height: 0.8,
	width: 0.5,
	floorOffset: 0,
	speed: .1
},7.5,2.8);

map.addObject({
	id: -1,// comedor 02

	color: 'transparent',
	texture: new Bitmap('img/flotantes/comedor_2.png', 1200, 1200),
	height: 0.8,
	width: 0.5,
	floorOffset: 0,
	speed: .1
},9.5,2.8);


map.addObject({
	id: -1,// comedor 03

	color: 'transparent',
	texture: new Bitmap('img/flotantes/comedor_3.png', 1200, 1200),
	height: 0.8,
	width: 0.5,
	floorOffset: 0,
	speed: .1
},8.5,3.2);

map.addObject({
	id: -1,// comedor 04

	color: 'transparent',
	texture: new Bitmap('img/flotantes/comedor_4.png', 1200, 1200),
	height: 0.8,
	width: 0.5,
	floorOffset: 0,
	speed: .1
},12,3.2);

map.addObject({
	id: -1,// comedor 05

	color: 'transparent',
	texture: new Bitmap('img/flotantes/comedor_5.png', 1200, 1200),
	height: 0.8,
	width: 0.5,
	floorOffset: 0,
	speed: .1
},10.5,3.9);

map.addObject({
	id: -1,// comedor 06

	color: 'transparent',
	texture: new Bitmap('img/flotantes/comedor_2.png', 1200, 1200),
	height: 0.8,
	width: 0.5,
	floorOffset: 0,
	speed: .1
},12.5,4.8);


map.addObject({
	id: -1,// comedor 07

	color: 'transparent',
	texture: new Bitmap('img/flotantes/comedor_3.png', 1200, 1200),
	height: 0.8,
	width: 0.5,
	floorOffset: 0,
	speed: .1
},8.5,5.5);

map.addObject({
	id: -1,// comedor 08

	color: 'transparent',
	texture: new Bitmap('img/flotantes/comedor_4.png', 1200, 1200),
	height: 0.8,
	width: 0.5,
	floorOffset: 0,
	speed: .1
},10,7);

map.addObject({
	id: -1,// comedor 09

	color: 'transparent',
	texture: new Bitmap('img/flotantes/comedor_5.png', 1200, 1200),
	height: 0.8,
	width: 0.5,
	floorOffset: 0,
	speed: .1
},11.5,5.5);

map.addObject({
	id: -1,// comedor 10

	color: 'transparent',
	texture: new Bitmap('img/flotantes/comedor_1.png', 1200, 1200),
	height: 0.8,
	width: 0.5,
	floorOffset: 0,
	speed: .1
},11.5,7.2);

map.addObject({
	id: -1,// comedor 11

	color: 'transparent',
	texture: new Bitmap('img/flotantes/comedor_6.png', 1200, 1200),
	height: 0.8,
	width: 0.5,
	floorOffset: 0,
	speed: .1
},10,5.5);


map.addObject({
	id: -1,// papelera 01

	color: 'transparent',
	texture: new Bitmap('img/flotantes/papeleras.png', 1200, 1200),
	height: 1,
	width: 0.5,
	floorOffset: 0,
	speed: .1
},10.5,1.3);

map.addObject({
	id: -1,// papelera 02

	color: 'transparent',
	texture: new Bitmap('img/flotantes/papeleras.png', 1200, 1200),
	height: 1,
	width: 0.5,
	floorOffset: 0,
	speed: .1
},8.5,1.3);

map.addObject({
	id: -1,// papelera 03

	color: 'transparent',
	texture: new Bitmap('img/flotantes/papeleras.png', 1200, 1200),
	height: 1,
	width: 0.5,
	floorOffset: 0,
	speed: .1
},12.5,2.5);

map.addObject({
	id: -1,// descomide

	color: 'transparent',
	texture: new Bitmap('img/flotantes/descomide.png', 1200, 1200),
	height: 1.2,
	width: 1,
	floorOffset: 0,
	speed: .1
},7.5,5.4);

map.addObject({
	id: -1,// dispensador-agua 01

	color: 'transparent',
	texture: new Bitmap('img/flotantes/dispensador-agua.png', 1200, 1200),
	height: 0.8,
	width: 0.5,
	floorOffset: 0,
	speed: .1
},12.5,5.5);

map.addObject({
	id: -1,// dispensador-agua 02

	color: 'transparent',
	texture: new Bitmap('img/flotantes/dispensador-agua.png', 1200, 1200),
	height: 0.8,
	width: 0.5,
	floorOffset: 0,
	speed: .1
},8.5,7.5);


/* map.addObject({
	id: -1,// lavado de manos

	color: 'yellow',
	texture: new Bitmap('img/flotantes/lavado-manos.png', 1200, 1200),
	height: 0.8,
	width: 0.5,
	floorOffset: 0,
	speed: .1
},7.3,6.5); */

map.addObject({
	id: -1,// maquina sola

	color: 'transparent',
	texture: new Bitmap('img/flotantes/maquina-sola.png', 1200, 1200),
	height: 1.2,
	width: 0.8,
	floorOffset: 0,
	speed: .1
},10,3.5);

map.addObject({
	id: -1,// unazuka

	color: 'transparent',
	texture: new Bitmap('img/flotantes/unazuka.png', 1200, 1200),
	height: 1.2,
	width: 0.8,
	floorOffset: 0,
	speed: .1
},11,3.5);

map.addObject({
	id: -1,// xua

	color: 'transparent',
	texture: new Bitmap('img/flotantes/xua.png', 1200, 1200),
	height: 1.2,
	width: 0.8,
	floorOffset: 0,
	speed: .1
},9,3.5);

//////////// SALA 2 ///////////

/* map.addObject({
	id: -1,// capsula1

	color: 'transparent',
	texture: new Bitmap('img/flotantes/capsula_1.png', 1200, 1200),
	height: 1.2,
	width: 0.8,
	floorOffset: 0,
	speed: .1
},4.5,17); */

/* map.addObject({
	id: -1,// capsula2

	color: 'transparent',
	texture: new Bitmap('img/flotantes/capsula_2.png', 1200, 1200),
	height: 1.2,
	width: 0.8,
	floorOffset: 0,
	speed: .1
},3.5,15.5); */

/* map.addObject({
	id: -1,// capsula3

	color: 'transparent',
	texture: new Bitmap('img/flotantes/capsula_3.png', 1200, 1200),
	height: 1.2,
	width: 0.8,
	floorOffset: 0,
	speed: .1
},1.5,19.5); */

/* map.addObject({
	id: -1,// capsula4

	color: 'transparent',
	texture: new Bitmap('img/flotantes/capsula_4.png', 1200, 1200),
	height: 1.2,
	width: 0.8,
	floorOffset: 0,
	speed: .1
},3.5,20.5); */


map.addObject({
	id: -1,// archivador

	color: 'transparent',
	texture: new Bitmap('img/flotantes/archivador.png', 1200, 1200),
	height: 0.8,
	width: 0.5,
	floorOffset: 0,
	speed: .1
},1.5,10.5);

map.addObject({
	id: -1,// estante

	color: 'transparent',
	texture: new Bitmap('img/flotantes/estante.png', 1200, 1200),
	height: 1.2,
	width: 0.8,
	floorOffset: 0,
	speed: .1
},10.5,20.5);

map.addObject({
	id: -1,// mesa

	color: 'transparent',
	texture: new Bitmap('img/flotantes/mesa.png', 1200, 1200),
	height: 1,
	width: 0.5,
	floorOffset: 0,
	speed: .1
},7.5,14.5);


//////////// SALA 3 ///////////

map.addObject({
	id: -1,// cancha 1

	color: 'transparent',
	texture: new Bitmap('img/flotantes/cancha_2.png', 1200, 1200),
	height: 1.2,
	width: 0.8,
	floorOffset: 0,
	speed: .1
},19.5,12.5);


map.addObject({
	id: -1,// cancha 2

	color: 'transparent',
	texture: new Bitmap('img/flotantes/cancha_1.png', 1200, 1200),
	height: 1.2,
	width: 0.8,
	floorOffset: 0,
	speed: .1
},19.5,18.5);

map.addObject({
	id: -1,// balon 1

	color: 'transparent',
	texture: new Bitmap('img/flotantes/balon_1.png', 1200, 1200),
	height: 0.8,
	width: 0.5,
	floorOffset: 0,
	speed: .1
},18.5,14.5);

map.addObject({
	id: -1,// balon 2

	color: 'transparent',
	texture: new Bitmap('img/flotantes/balon_2.png', 1200, 1200),
	height: 0.8,
	width: 0.5,
	floorOffset: 0,
	speed: .1
},19.2,13.5);

map.addObject({
	id: -1,// balon 3

	color: 'transparent',
	texture: new Bitmap('img/flotantes/balon_2.png', 1200, 1200),
	height: 0.8,
	width: 0.5,
	floorOffset: 0,
	speed: .1
},20,18.5);


/* map.addObject({
	id: -1,// capsula 5

	color: 'transparent',
	texture: new Bitmap('img/flotantes/capsula_5.png', 1200, 1200),
	height: 0.8,
	width: 0.5,
	floorOffset: 0,
	speed: .1
},18.2,18.5); */

/* map.addObject({
	id: -1,// capsula 6

	color: 'transparent',
	texture: new Bitmap('img/flotantes/capsula_6.png', 1200, 1200),
	height: 0.8,
	width: 0.5,
	floorOffset: 0,
	speed: .1
},20.8,10.5); */

map.addObject({
	id: -1,// canecas 1

	color: 'transparent',
	texture: new Bitmap('img/flotantes/canecas.png', 1200, 1200),
	height: 0.8,
	width: 0.5,
	floorOffset: 0,
	speed: .1
},20.5,13.5);

map.addObject({
	id: -1,// canecas 2

	color: 'transparent',
	texture: new Bitmap('img/flotantes/canecas.png', 1200, 1200),
	height: 0.8,
	width: 0.5,
	floorOffset: 0,
	speed: .1
},20.5,17.5);



document.getElementById('BtnFullScreen').addEventListener('click', function(){
	let bd = document.getElementsByTagName('body')[0];
	if(this.classList.contains('active')){
		this.classList.remove('active');
		document.exitFullscreen();
	}
	else{
		this.classList.add('active');
		bd.requestFullscreen();
	}
});

document.getElementById('BtnSound').addEventListener('click', function(){
	if(this.classList.contains('active')){
		this.classList.remove('active');
		mute = false;
		utils.sfx('fondo-escenario', { volume: 0.2, loop: true });
	}
	else{
		utils.stopAllSounds();
		this.classList.add('active');
		mute = true;
	}
});

document.getElementById('BtnInstruction').addEventListener('click', function(){
	document.getElementById('ModalInstrucciones').classList.add('active');
});

document.querySelector('.btn-close-instruction').addEventListener('click', function() { 
	document.getElementById('ModalInstrucciones').classList.remove('active');
});

document.querySelector('#BtnSettings').addEventListener('click', function() {
	document.getElementById('Settings').style.display = 'block';
});

document.querySelector('#BtnContinueGame').addEventListener('click', function() {
	document.getElementById('Settings').style.display = 'none';
});

/* document.querySelector('#notification').addEventListener('click', function() {
	let audio = this.getAttribute('data-audio');
	let _this=this;
	_this.style.display = 'none';
	utils.sfx(audio, {volume:1, loop:false}).on('end',function(){
		_this.style.display = 'none';

	})
}); */


// document.querySelector('#BtnCharacter').addEventListener('click', openCharacter);
//document.querySelector('#Character .close-popup').addEventListener('click', closeCharacter);
function setPlayerPosition(){
	player = new Player(config.player.posX, config.player.posY, config.player.dir);
}
function init() {
	utils.stopAllSounds();
	utils.sfx('fondo-escenario', { volume: 0.2, loop: true });
	map.wallGrid = config.level;
	openCharacter();
	loop.start(function frame(seconds) {
		//map.update(seconds);
		let progress = Math.round((82/config.totalPoints) * config.score);
		objects.update();
		player.update(controls.states, map, seconds);
		camera.render(player, map, objects);
		document.querySelector('.progress-bar .bar').style.width = progress + '%';
		for(let object of map.objects){
			if(object.id == -1) continue;
			if(object.distanceFromPlayer < 1 )
			{
				if(object.distanceFromPlayer < 0.8 && Math.abs(object.render.angleToPlayer) < 0.6){
					document.querySelector('.click-modal').style.display = 'flex';
					document.querySelector('.text-open-modal').innerText = object.popup;
					if(PRESS){
						RUN = false;
						PRESS = false;
						config.objects.forEach( el => {
							if(el.id == object.id)
								el.state = false;

							
						});
						switch(object.actividad){
							case 'seleccion-unica':
								activity = new UniqueSelection(object);
								break;
							case 'seleccion-multiple':
								activity = new MultipleSelection(object);
								break;
							case 'arrastre':
								activity = new DragAndDrop(object);
								break;
							case 'lupa':
								activity = new Magnify(object);
								break;
							case 'input':
								activity = new FieldInput(object);
								break;
							case 'html':
								activity = new HtmlContent(object);
								break;
							case 'cartas':
								activity = new PairCards(object); 
								break;
						}

						switch(object.id){
							case 'act9':
								document.getElementById('Capsula1').classList.add('active');
								break;
							case 'act10':
								document.getElementById('Capsula2').classList.add('active');
								break;
							case 'act14':
								document.getElementById('Capsula3').classList.add('active');
								break;
							case 'act15':
								document.getElementById('Capsula4').classList.add('active');
								break;
							case 'act23':
								document.getElementById('Capsula5').classList.add('active');
								break;
							case 'act24':
								document.getElementById('Capsula6').classList.add('active');
								break;
						}
						document.getElementById('ModalActivity').classList.add(object.id);
					}
				}
				else {
					document.querySelector('.click-modal').style.display = 'none';
				}
			}
		}
		saveSuspendData();
		
	});
	modalIntro.classList.remove('active');
}

function closeCharacter(){
	popupCharacter.classList.remove('active');
	utils.stopAllSounds();
	utils.sfx('fondo-escenario', { volume: 0.2, loop: true });
	utils.sfx('fondo-oficina', { volume: 1.5, loop: true });
}

function openCharacter() {
	if(indexPista.length > 0){
		popupCharacter.classList.add('active');
		popupCharacter.querySelector('.content').innerHTML = indexPista;
		// utils.sfx(pistas[indexPista].audioId, { volume: 0.5, loop: false});
	}
}

function modalFinal() {
	closeCharacter();
	//document.querySelector('#ModalFin').classList.add('active');		
}

function selectCharacter(_gender){
	let bd = document.getElementsByTagName('body')[0];
	bd.requestFullscreen();
	if(_gender == 'w'){
		document.querySelector('.hand').classList.add('woman');
		document.querySelector('#BtnSettings img').src = 'img/interfaz/icon-character-woman.png';
	}
	else {
		document.querySelector('.hand').classList.add('man');
		document.querySelector('#BtnSettings img').src = 'img/interfaz/icon-character-man.png';
	}
	initScorm();
}