function Map(size) {
	this.size = size;
	this.wallGrid = [];
	this.backgrounds = { 
		"interior": new Bitmap('img/fondo_interior.png', 2400, 1120),
		"patio": new Bitmap('img/fondo_patio.png', 2400, 1120)
	}
	this.skybox = this.backgrounds['interior'];
	this.casa1 = new Bitmap('img/paredes/01.png', 1200, 1200);
	this.casa2 = new Bitmap('img/paredes/02.png', 1200, 1200);
	this.casa3 = new Bitmap('img/paredes/03.png', 1200, 1200);
	this.casa4 = new Bitmap('img/paredes/04.png', 1200, 1200);
	this.casa5 = new Bitmap('img/paredes/05.png', 1200, 1200);
	this.casa6 = new Bitmap('img/paredes/06.png', 1200, 1200);
	this.casa7 = new Bitmap('img/paredes/07.png', 1200, 1200);
	this.casa8 = new Bitmap('img/paredes/08.png', 1200, 1200);
	this.casa9 = new Bitmap('img/paredes/09.png', 1200, 1200);
	this.casa10 = new Bitmap('img/paredes/10.png', 1200, 1200);
	this.casa11 = new Bitmap('img/paredes/11.png', 1200, 1200);
	this.casa12 = new Bitmap('img/paredes/12.png', 1200, 1200);
	this.casa13 = new Bitmap('img/paredes/13.png', 1200, 1200);
	this.casa14 = new Bitmap('img/paredes/14.png', 1200, 1200);
	this.casa15 = new Bitmap('img/paredes/15.png', 1200, 1200);
	this.casa16 = new Bitmap('img/paredes/16.png', 1200, 1200);
	this.casa17 = new Bitmap('img/paredes/17.png', 1200, 1200);
	this.casa18 = new Bitmap('img/paredes/18.png', 1200, 1200);
	this.casa19 = new Bitmap('img/paredes/19.png', 1200, 1200);
	this.casa20 = new Bitmap('img/paredes/20.png', 1200, 1200);
	this.casa21 = new Bitmap('img/paredes/21.png', 1200, 1200);
	this.casa22 = new Bitmap('img/paredes/22.png', 1200, 1200);
	this.casa23 = new Bitmap('img/paredes/23.png', 1200, 1200);
	this.casa24 = new Bitmap('img/paredes/24.png', 1200, 1200);
	this.casa25 = new Bitmap('img/paredes/25.png', 1200, 1200);
	this.casa26 = new Bitmap('img/paredes/26.png', 1200, 1200);
	this.casa27 = new Bitmap('img/paredes/27.png', 1200, 1200);
	this.casa28 = new Bitmap('img/paredes/28.png', 1200, 1200);
	this.casa29 = new Bitmap('img/paredes/29.png', 1200, 1200);
	this.casa30 = new Bitmap('img/paredes/30.png', 1200, 1200);
	this.casa31 = new Bitmap('img/paredes/31.png', 1200, 1200);
	this.casa32 = new Bitmap('img/paredes/32.png', 1200, 1200);
	this.casa33 = new Bitmap('img/paredes/33.png', 1200, 1200);
	this.casa34 = new Bitmap('img/paredes/34.png', 1200, 1200);
	this.casa35 = new Bitmap('img/paredes/35.png', 1200, 1200);
	this.casa36 = new Bitmap('img/paredes/36.png', 1200, 1200);
	this.casa37 = new Bitmap('img/paredes/37.png', 1200, 1200);
	this.casa38 = new Bitmap('img/paredes/38.png', 1200, 1200);
	this.casa39 = new Bitmap('img/paredes/39.png', 1200, 1200);
	this.casa40 = new Bitmap('img/paredes/40.png', 1200, 1200);
	this.casa41 = new Bitmap('img/paredes/41.png', 1200, 1200);
	this.casa42 = new Bitmap('img/paredes/42.png', 1200, 1200);
	this.casa43 = new Bitmap('img/paredes/43.png', 1200, 1200);
	this.casa44 = new Bitmap('img/paredes/44.png', 1200, 1200);
	this.casa45 = new Bitmap('img/paredes/45.png', 1200, 1200);
	this.casa46 = new Bitmap('img/paredes/46.png', 1200, 1200);
	this.casa47 = new Bitmap('img/paredes/47.png', 1200, 1200);
	this.casa48 = new Bitmap('img/paredes/48.png', 1200, 1200);
	this.casa49 = new Bitmap('img/paredes/49.png', 1200, 1200);
	this.casa50 = new Bitmap('img/paredes/50.png', 1200, 1200);
	this.casa51 = new Bitmap('img/paredes/51.png', 1200, 1200);
	this.casa52 = new Bitmap('img/paredes/52.png', 1200, 1200);
	this.casa53 = new Bitmap('img/paredes/53.png', 1200, 1200);
	this.casa54 = new Bitmap('img/paredes/54.png', 1200, 1200);

	this.light = 0;
	this.objects = [];
}

Map.prototype.get = function(x, y) {
	x = Math.floor(x);
	y = Math.floor(y);
	if (x < 0 || x > this.size - 1 || y < 0 || y > this.size - 1) return -1;
	return this.wallGrid[y * this.size + x];
};

Map.prototype.getObject = function(x,y) {
	x = Math.floor(x);
	y = Math.floor(y);
	return this.objects[y * this.size + x];
};

Map.prototype.randomize = function() {
	for (var i = 0; i < this.size * this.size; i++) {
		this.wallGrid[i] = Math.random() < 0.3 ? 1 : 0;
	}
};

Map.prototype.cast = function(point, angle, range) {
	var self = this,
		sin = Math.sin(angle),
		cos = Math.cos(angle),
		noWall = {
			length2: Infinity
		};

	return ray({
		x: point.x,
		y: point.y,
		height: 0,
		distance: 0
	});

	function ray(origin) {
		var stepX = step(sin, cos, origin.x, origin.y);
		var stepY = step(cos, sin, origin.y, origin.x, true);
		var nextStep = stepX.length2 < stepY.length2 
						? inspect(stepX, 1, 0, origin.distance, stepX.y) 
						: inspect(stepY, 0, 1, origin.distance, stepY.x);

		if (nextStep.distance > range) return [origin];    
		return [origin].concat(ray(nextStep));
	}

	function step(rise, run, x, y, inverted) {
		if (run === 0) return noWall;
		var dx = run > 0 ? Math.floor(x + 1) - x : Math.ceil(x - 1) - x;
		var dy = dx * (rise / run);
		return {
			x: inverted ? y + dy : x + dx,
			y: inverted ? x + dx : y + dy,
			length2: dx * dx + dy * dy
		};
	}

	function inspect(step, shiftX, shiftY, distance, offset) {
		var dx = cos < 0 ? shiftX : 0;
		var dy = sin < 0 ? shiftY : 0;
		step.value = self.get(step.x - dx, step.y - dy);
		step.height = self.get(step.x - dx, step.y - dy);
		step.distance = distance + Math.sqrt(step.length2);
		step.object = self.getObject(step.x - dx, step.y - dy);
		if (shiftX) step.shading = cos < 0 ? 2 : 0;
		else step.shading = sin < 0 ? 2 : 1;
		step.offset = offset - Math.floor(offset);
		return step;
	}
};

Map.prototype.setBackground = function(_bg) {
	this.skybox = this.backgrounds[_bg];
}

Map.prototype.update = function(seconds) {
	if (this.light > 0) this.light = Math.max(this.light - 10 * seconds, 0);
	else if (Math.random() * 5 < seconds) this.light = 2;
};

Map.prototype.addObject = function(object,x,y){
	this.objects.push( new MapObject(object,x,y) );
};