function Player(x, y, direction) {
	this.x = x;
	this.y = y;
	this.direction = direction;
	this.maxStamina = 10;
	this.stamina = this.maxStamina;
	
	this.paces = 0;
}

Player.prototype.rotate = function(angle) {
	this.direction = (this.direction + angle + CIRCLE) % (CIRCLE);
	config.player.dir = this.direction;
};

Player.prototype.walk = function(distance, angle, map) {
	var dx = Math.cos(this.direction + angle) * distance;
	var dy = Math.sin(this.direction + angle) * distance;
	if (map.get(this.x + dx, this.y) <= 0) this.x += dx;
	if (map.get(this.x, this.y + dy) <= 0) this.y += dy;
	config.player.posX = this.x;
	config.player.posY = this.y;
	this.paces += distance;
};

Player.prototype.update = function(controls, map, seconds) {

	var speed = controls.running && player.stamina > 0 ?  3 : 1.5;

	if (controls.forward) this.walk(speed * seconds, 0,map);
	if (controls.backward) this.walk(-speed * seconds, 0,map);

	if(!camera.fullscreen){ //todo: make this not rely on globals
		if (controls.left) this.rotate(-Math.PI * seconds);
		if (controls.right) this.rotate(Math.PI * seconds);
	} else {
		if (controls.left) this.walk(-speed / 2 * seconds, Math.PI * .5, map);
		if (controls.right) this.walk(speed / 2 * seconds, Math.PI * .5 ,map);
	}

	if(controls.running && player.stamina > -1){
		player.stamina-=.1;
	} else if(player.stamina < 10) {
		player.stamina+=.5;
	}
};