const utils = {
	readJsonFile: (file, callback) => {
		var xhr = new XMLHttpRequest();
		xhr.overrideMimeType("application/json");
		xhr.open("GET", file, true);
		xhr.onreadystatechange = function() {
			if (xhr.readyState === 4 && xhr.status == "200") {
				callback(xhr.responseText);
			}
		}
		xhr.send(null);
	},
    createImageBitmap : async (data) => {
        return new Promise((resolve,reject) => {
			let dataURL;
			if (data instanceof Blob) {
				dataURL = URL.createObjectURL(data);
			} else if (data instanceof ImageData) {
				const canvas = document.createElement('canvas');
				const ctx = canvas.getContext('2d');
				canvas.width = data.width;
				canvas.height = data.height;
				ctx.putImageData(data,0,0);
				dataURL = canvas.toDataURL();
			} else {
				throw new Error('createImageBitmap does not handle the provided image source type');
			}
			const img = document.createElement('img');
			img.addEventListener('load',function () {
				resolve(this);
			});
			img.src = dataURL;
		});
    },
	sfx: (sound, options) => {
		options = options || {};
		options.volume = options.volume===undefined ? 1 : options.volume;
		options.loop = options.loop===undefined ? false : options.loop;
		let sfx = Library.sounds[sound];
		if(sfx.playing())
			sfx.stop();

		if(mute){
			sfx.volume(0);
		}
		else{
			sfx.volume(options.volume);
		}

		sfx.loop(options.loop);
		sfx.play();
		return sfx;
	},
	stopAllSounds: () => {
		Object.keys(Library.sounds).forEach(function(name){
			Library.sounds[name].stop();
		});
	}
}

function Bitmap(src, width, height) {
	this.image = new Image();
	this.image.src = src;
	this.width = width;
	this.height = height;
}

function MapObject(object,x,y){
	for(var prop in object){
		this[prop] = object[prop];
	}
	this.x = x;
	this.y = y;
}